
function clearTraitALevel(entity){
    entity.getCapability($HostileEntity.CAPABILITY).ifPresent(mobTraitCap => {
        let traits = mobTraitCap.traits;
        let entries = traits.entrySet();
        if (entries.length === 0 && mobTraitCap.getLevel()===0 ) { return }
        mobTraitCap.setLevel(entity, 0)
        for (let entry of entries) {
            mobTraitCap.setTrait(entry.getKey().getID(), 0)
        }
        entity.server.scheduleInTicks(1, () => {
            mobTraitCap.syncToClient(entity)
        })
    })
}
const attributes = [
    { id: 'minecraft:generic.max_health', uuid: "17531b18-91d1-4c3f-affa-910335e07117" },
    { id: 'minecraft:generic.movement_speed', uuid: "83f0db9f-c494-4afd-b06e-c98c3bc84116" },
    { id: 'minecraft:generic.armor', uuid: "1f3e9cfe-92c5-4334-990e-932b27611f09" },
    { id: 'minecraft:generic.armor_toughness', uuid: "457aaba5-6a26-47e5-a7e7-991d9418483b" },
    { id: 'minecraft:generic.follow_range', uuid: "8f1a8333-1d10-47ed-8897-b771c96444c1" },
    { id: 'minecraft:generic.attack_speed', uuid: "eb70c093-a8f0-4730-a917-778659b6d0c2" },
    { id: 'minecraft:generic.attack_damage', uuid: "cf92da9f-cd22-4f53-b465-0bd3d65aed0f" },
    { id: 'minecraft:generic.knockback_resistance', uuid: "5df775dd-f316-47aa-b345-95cfe4b3bb5c" },
    { id: 'minecraft:generic.flying_speed', uuid: "ca5a4b09-1c05-4abb-b1b5-427b534b6e13" },
    { id: 'minecraft:zombie.spawn_reinforcements', uuid: "808b25b7-2c8f-4efa-b7db-0555d2bf135e" },
    { id: 'l2damagetracker:magic_damage', uuid: "29d1960b-e4e1-41b4-ae4d-5bc204e4166e" },
    { id: 'irons_spellbooks:spell_resist', uuid: "be330043-4c39-4d60-855e-0998ef21a3ce" },
    { id: 'attributeslib:arrow_damage', uuid: "bb39674c-b9c6-40f8-b5e3-1fbc83bfc3e0" },
    { id: 'attributeslib:arrow_velocity', uuid: "f69d5fa6-c958-44df-839f-15450f581938" },
    { id: 'forge:swim_speed', uuid: "dff21909-33c2-45f7-bed6-169151733886" },
    { id: 'forge:step_height_addition', uuid: "12231f16-e4e2-4f35-952a-fb6b5a47f4e7" },
    { id: 'attributeslib:armor_pierce', uuid: "55638f0c-8b36-4348-a056-a90f7fbef01d" },
    { id: 'attributeslib:armor_shred', uuid: "ca4e5c91-7ee9-4fd3-bbd4-fa67badd3a5c" },
    { id: 'attributeslib:life_steal', uuid: "b287d769-bb68-48f3-aea3-7abc900ff19e" },
    { id: 'attributeslib:prot_pierce', uuid: "13eaf894-f04b-4e5f-8764-1beb70864344" },
    { id: 'attributeslib:prot_shred', uuid: "a299aa90-abc4-4fba-8345-9a63aa887c03" }
]
const equipmentSlots = [
    'head',
    'chest',
    'legs',
    'feet',
    'mainhand',
    'offhand'
]
function clearBuff(entity) {
    equipmentSlots.forEach(slot => {
        entity.setItemSlot(slot, "minecraft:air");
    })
    entity.potionEffects.clear()
    if (entity.getAttribute('minecraft:generic.max_health').getModifier("17531b18-91d1-4c3f-affa-910335e07117") === null) { return }
    attributes.forEach(attr => {
        if (entity.getAttribute(attr.id) === null) { return }
        if (entity.getAttribute(attr.id).getModifier(attr.uuid) === null) { return }
        entity.getAttribute(attr.id).removeModifier(attr.uuid)
    })
}
EntityEvents.hurt(event => {
    if (!event.entity || event.entity.isPlayer()) { return }
    if (!event.entity.isAlive()) { return }
    if (event.getSource().getPlayer() === null) { return }
    let player = event.getSource().getPlayer()
    if (!player.isAlive()) { return }
    if (event.type === null) { return }
    let entity = event.entity
    if (entity.type === "touhou_little_maid:maid") { return }
    if ($CurioCompat.hasItemInCurioOrSlot(player, Item.of("kubejs:origin_eye"))) {
        clearTraitALevel(entity)
        clearBuff(entity)
    }
})
EntityEvents.hurt(event => {
    if (!event.entity.isAlive()) { return }
    if (!event.entity.isPlayer()) { return }
    if (event.getSource() == null) { return }
    let player = event.entity
    if (event.getSource().getActual() === null) { return }
    let source = event.getSource().getActual()
    if (source.type === "touhou_little_maid:maid" || source.type === "minecraft:player") { return }
    if ($CurioCompat.hasItemInCurioOrSlot(player, Item.of("kubejs:origin_eye"))) {
        clearTraitALevel(source)
        clearBuff(source)
    }
})
